var backgrounds_red,
	overlays


function backgroundsAndOverlay_init()
{
	//	generate a few pixellated red backgrounds
	backgrounds_red = [];
	for( var i=0; i<8; i++ )
	{
		var tmpCanvas			= document.createElement('canvas')
			tmpCanvasContext	= tmpCanvas.getContext('2d');

		tmpCanvas.width		= 320
		tmpCanvas.height	= 160

		var	size = 32;
		for( var y=0;y<160;y+=size )
		{
			for( var x=0;x<320;x+=size )
			{
				tmpCanvasContext.fillStyle = '#'+ ('0'+Math.max( 0, Math.min( 255,Math.round( Math.random()*(1+i)/8*512+(i/7)*128 )-128 ))).slice(-2) +'0000'
				tmpCanvasContext.fillRect( x,y,size,size );
			}
		}
		backgrounds_red.push( tmpCanvas );
	}




	//	generate some B&W overlay texts
	var texts = []
	texts.push({id:'17',data:
		[
			'       ',
			' 0 000 ',
			' 0   0 ',
			' 0  00 ',
			' 0   0 ',
			' 0   0 ',
			'       '
		]})
	texts.push({id:'neja nova',data:
		[
			'                                  ',
			'  oo  oo  o  oo    oo  oo o o  oo ',
			' o o o    o o o   o o o o o o o o ',
			' o o ooo  o o o   o o o o o o o o ',
			' o o o    o ooo   o o o o o o ooo ',
			' o o ooo o  o o   o o oo   o  o o ',
			'                                  '
		]})

	texts.push({id:'the javascript only demo',data:
		[
			'                                                                                        ',
			' ooo o o  oo    o  oo o o  oo  oo  oo  oo o  oo ooo    oo  oo o   o o   oo   oo o o  oo ',
			'  o  o o o      o o o o o o o o   o   o o o o o  o    o o o o o   o o   o o o   ooo o o ',
			'  o  ooo ooo    o o o o o o o  o  o   o o o o o  o    o o o o o    o    o o ooo o o o o ',
			'  o  o o o      o ooo o o ooo   o o   oo  o oo   o    o o o o o    o    o o o   o o o o ',
			'  o  o o ooo   o  o o  o  o o oo  ooo o o o o    o    oo  o o  oo  o    ooo ooo o o oo  ',
			'                                                                                        '
		]})
	texts.push({id:'plugins are for the weak',data:
		[
			'                                                                                       ',
			'  oo o   o o  o  o oo   oo    oo  oo  oo   ooo  oo  oo   ooo o o  oo   o o  oo  oo o o ',
			' o o o   o o o   o o o o     o o o o o     o   o o o o    o  o o o     o o o   o o oo  ',
			' o o o   o o o o o o o  o    o o o o ooo   ooo o o o o    o  ooo ooo   o o ooo o o ooo ',
			' oo  o   o o o o o o o   o   ooo oo  o     o   o o oo     o  o o o     ooo o   ooo o o ',
			' o    oo ooo  oo o o o oo    o o o o ooo   o   oo  o o    o  o o ooo   o o ooo o o o o ',
			'                                                                                       '
		]})



	variants = ['#fff','inverse #fff','#f00','inverse #f00','#000','inverse #000','#0cf','inverse #0cf'];
	overlays = {}

	while( currentText=texts.pop() )
	{
		for( var i=0,variant; variant=variants[i]; i++ )
		{
			var size				= 16,
				tmpCanvas			= document.createElement('canvas')
				tmpCanvasContext	= tmpCanvas.getContext('2d');

			tmpCanvas.width		= size*currentText.data[0].length
			tmpCanvas.height	= size*currentText.data.length

			tmpCanvasContext.fillStyle	= variant.slice( -4 );
			var isInverse = variant.indexOf('inverse')+1

			for( var y=0;y<currentText.data.length;y++ )
			{
				for( var x=0;x<currentText.data[0].length;x++ )
				{
					if( isInverse ^ currentText.data[y][x]!=' ' )
						tmpCanvasContext.fillRect( x*size,y*size,size,size );
				}
			}
			overlays[ currentText.id+' '+variant ] = tmpCanvas
		}
	}




	//	done
	progressBarIndex++;
}

